/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryLocator {
    private BlockPos inventoryCoordinate = null;
    private Direction inventorySide = null;

    @Nonnull
    private LazyOptional<IItemHandler> getItemHandlerAtDirection(Level worldObj, BlockPos thisCoordinate, Direction direction) {
        if (direction == null) {
            if (this.inventoryCoordinate != null) {
                return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
            }
            return LazyOptional.empty();
        }
        BlockEntity te = worldObj.m_7702_(thisCoordinate);
        if (te == null) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).map(handler -> {
            this.inventoryCoordinate = thisCoordinate.m_142300_(direction);
            this.inventorySide = direction.m_122424_();
            return this.getItemHandlerAtCoordinate(worldObj, this.inventoryCoordinate, this.inventorySide);
        }).orElse(LazyOptional.empty());
    }

    @Nonnull
    private LazyOptional<IItemHandler> getItemHandlerAtCoordinate(Level worldObj, BlockPos c, Direction direction) {
        BlockEntity te = worldObj.m_7702_(c);
        if (te == null) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
    }

    public void ejectStack(Level worldObj, BlockPos pos, ItemStack stack, BlockPos thisCoordinate, Direction[] directions) {
        for (Direction dir : directions) {
            if (stack.m_41619_()) break;
            ItemStack finalStack = stack;
            stack = this.getItemHandlerAtDirection(worldObj, thisCoordinate, dir).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)finalStack, (boolean)false)).orElse(stack);
        }
        if (!stack.m_41619_()) {
            ItemEntity entityItem = new ItemEntity(worldObj, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            worldObj.m_7967_((Entity)entityItem);
        }
    }

    public Direction getInventorySide() {
        return this.inventorySide;
    }
}

